SuperStrict

' Example 3: Asynchronous Speech
' Demonstrates: SPF_ASYNC, IsSpeaking(), PauseSpeech(), ResumeSpeech()

Framework BRL.StandardIO

Import "-L."
Import "-lBlitzSpeech"
Include "BlitzSpeechH.bmx"

Print "BlitzSpeech - Asynchronous Speech Example"

Print ""

If InitSpeech() = SP_INIT_SUCCESS Then
    
    ' Start speaking in background
    Print "Starting async speech in background..."
    SpeakTextFlags("This is a long sentence being spoken asynchronously while the program continues to do other work in the background.", SPF_ASYNC)
    Print ""
    
	' Do a slight delay because there is a race issue, basically
	' it takes a bit of time for SAPI to process the text in the
	' function before it starts speaking. Commenting the delay out
	' will show this.
	Delay(2000)
	
    ' Do some work while speech is happening
    Print "Doing work while speech is playing:"
    For Local i:Int = 1 To 20
        Print "  Working... " + i + "/20"
        Delay(200)
        
        ' Check if speaking
        If IsSpeaking() = SP_IS_SPEAKING_NO Then
            Print "  (No speech is being outputted!)"
        End If
    Next
    Print "Work complete!"
    Print ""
    
    ' Compare with synchronous (blocking) speech
    Print "Now compare with SYNCHRONOUS (blocking) speech..."
    Print "Starting speech (this will block)..."
    SpeakText("This is synchronous speech. The program is frozen until I finish speaking.")
    Print "Speech finished! (See how it blocked?)"
    Print ""
    
    ' Test pause and resume with async
    Print "Testing pause and resume with async..."
    SpeakTextFlags("This speech will be paused in the middle, then resumed after a delay.", SPF_ASYNC)
    Delay(2000)
    
    Print "  PAUSING speech..."
    PauseSpeech()
    
    ' Do work while paused
    For Local i:Int = 1 To 5
        Print "  Doing work while paused... " + i
        Delay(500)
    Next
    
    Print "  RESUMING speech..."
    ResumeSpeech()
    WaitUntilSpeechIsDone(10000)
    Print ""
    
    CleanupSpeech()
    Print "Done!"
Else
    Print "Failed to initialize speech!"
EndIf